/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.sound.OnePerPlayerSounds;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class AttachmentSound {
    public static final AttachmentSound NONE = new AttachmentSound(null, 0.0f, 0.0f, null, 0.0f, 0.0f);
    public static final AttachmentSound FILM = new AttachmentSound(Exposure.SoundEvents.FILM_ADVANCING, 0.9f, 1.0f, Exposure.SoundEvents.FILM_REMOVED, 0.7f, 1.0f);
    public static final AttachmentSound FLASH = new AttachmentSound(Exposure.SoundEvents.CAMERA_GENERIC_CLICK, 0.6f, 1.15f, Exposure.SoundEvents.CAMERA_GENERIC_CLICK, 0.35f, 0.95f);
    public static final AttachmentSound LENS = new AttachmentSound(Exposure.SoundEvents.LENS_INSERT, 1.0f, 1.0f, Exposure.SoundEvents.LENS_REMOVE, 1.0f, 1.0f);
    public static final AttachmentSound FILTER = new AttachmentSound(Exposure.SoundEvents.FILTER_INSERT, 0.8f, 1.0f, Exposure.SoundEvents.FILTER_REMOVE, 0.5f, 1.0f);
    @Nullable
    private final Supplier<SoundEvent> inserted;
    private final float insertedVolume;
    private final float insertedPitch;
    @Nullable
    private final Supplier<SoundEvent> removed;
    private final float removedVolume;
    private final float removedPitch;

    public AttachmentSound(@Nullable Supplier<SoundEvent> inserted, float insertedVolume, float insertedPitch, @Nullable Supplier<SoundEvent> removed, float removedVolume, float removedPitch) {
        this.inserted = inserted;
        this.insertedVolume = insertedVolume;
        this.insertedPitch = insertedPitch;
        this.removed = removed;
        this.removedVolume = removedVolume;
        this.removedPitch = removedPitch;
    }

    public AttachmentSound(@Nullable Supplier<SoundEvent> inserted, float insertedVolume, float insertedPitch) {
        this.inserted = inserted;
        this.insertedVolume = insertedVolume;
        this.insertedPitch = insertedPitch;
        this.removed = null;
        this.removedVolume = 1.0f;
        this.removedPitch = 1.0f;
    }

    public void playOnePerPlayer(Player player, boolean isRemoved) {
        Supplier<SoundEvent> sound;
        Supplier<SoundEvent> supplier = sound = isRemoved ? this.getRemoved() : this.getInserted();
        if (sound != null) {
            OnePerPlayerSounds.play(player, sound.get(), SoundSource.PLAYERS, isRemoved ? this.getRemovedVolume() : this.getInsertedVolume(), isRemoved ? this.getRemovedPitch() : this.getInsertedPitch());
        }
    }

    @Nullable
    public Supplier<SoundEvent> getInserted() {
        return this.inserted;
    }

    public float getInsertedVolume() {
        return this.insertedVolume;
    }

    public float getInsertedPitch() {
        return this.insertedPitch;
    }

    @Nullable
    public Supplier<SoundEvent> getRemoved() {
        return this.removed;
    }

    public float getRemovedVolume() {
        return this.removedVolume;
    }

    public float getRemovedPitch() {
        return this.removedPitch;
    }
}

